//*****************************************************************************
//
// Microsoft Windows Media Technologies
// Copyright (C) Microsoft Corporation. All rights reserved.
//
// FileName:            wmpids.h
//
// Abstract:            Dispatch ID definitions for all public Windows Media
//                      Player Interfaces
//
//*****************************************************************************



//////////////////////////////////////////////////////////////////////
// Definitions
//////////////////////////////////////////////////////////////////////
#define DISPID_DELTA                            50


//////////////////////////////////////////////////////////////////////
// IWMPCore
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPCORE_BASE                     0
#define DISPID_WMPCORE_URL                      DISPID_WMPCORE_BASE + 1
#define DISPID_WMPCORE_OPENSTATE                DISPID_WMPCORE_BASE + 2
#define DISPID_WMPCORE_CLOSE                    DISPID_WMPCORE_BASE + 3
#define DISPID_WMPCORE_CONTROLS                 DISPID_WMPCORE_BASE + 4
#define DISPID_WMPCORE_SETTINGS                 DISPID_WMPCORE_BASE + 5
#define DISPID_WMPCORE_CURRENTMEDIA             DISPID_WMPCORE_BASE + 6
#define DISPID_WMPCORE_NETWORK                  DISPID_WMPCORE_BASE + 7
#define DISPID_WMPCORE_MEDIACOLLECTION          DISPID_WMPCORE_BASE + 8
#define DISPID_WMPCORE_PLAYLISTCOLLECTION       DISPID_WMPCORE_BASE + 9
#define DISPID_WMPCORE_PLAYSTATE                DISPID_WMPCORE_BASE + 10
#define DISPID_WMPCORE_VERSIONINFO              DISPID_WMPCORE_BASE + 11
#define DISPID_WMPCORE_LAUNCHURL                DISPID_WMPCORE_BASE + 12
#define DISPID_WMPCORE_CURRENTPLAYLIST          DISPID_WMPCORE_BASE + 13
#define DISPID_WMPCORE_CDROMCOLLECTION          DISPID_WMPCORE_BASE + 14
#define DISPID_WMPCORE_CLOSEDCAPTION            DISPID_WMPCORE_BASE + 15
#define DISPID_WMPCORE_ISONLINE                 DISPID_WMPCORE_BASE + 16
#define DISPID_WMPCORE_ERROR                    DISPID_WMPCORE_BASE + 17
#define DISPID_WMPCORE_STATUS                   DISPID_WMPCORE_BASE + 18
#define DISPID_WMPCORE_LAST                     DISPID_WMPCORE_STATUS

//////////////////////////////////////////////////////////////////////
// IPlayer
//////////////////////////////////////////////////////////////////////

#define DISPID_WMPOCX_BASE                  (DISPID_WMPCORE_LAST)
#define DISPID_WMPOCX_ENABLED               (DISPID_WMPOCX_BASE + 1)
#define DISPID_WMPOCX_TRANSPARENTATSTART    (DISPID_WMPOCX_BASE + 2)
#define DISPID_WMPOCX_FULLSCREEN            (DISPID_WMPOCX_BASE + 3)
#define DISPID_WMPOCX_ENABLECONTEXTMENU     (DISPID_WMPOCX_BASE + 4)
#define DISPID_WMPOCX_UIMODE                (DISPID_WMPOCX_BASE + 5)
#define DISPID_WMPOCX_LAST                  DISPID_WMPOCX_UIMODE

#define DISPID_WMPOCX2_BASE                 (DISPID_WMPOCX_LAST)
#define DISPID_WMPOCX2_STRETCHTOFIT         (DISPID_WMPOCX2_BASE + 1)
#define DISPID_WMPOCX2_WINDOWLESSVIDEO      (DISPID_WMPOCX2_BASE + 2)
#define DISPID_WMPOCX4_ISREMOTE             (DISPID_WMPOCX2_BASE + 3)
#define DISPID_WMPOCX4_PLAYERAPPLICATION    (DISPID_WMPOCX2_BASE + 4)
#define DISPID_WMPOCX4_OPENPLAYER           (DISPID_WMPOCX2_BASE + 5)


//////////////////////////////////////////////////////////////////////
// IWMPCore2
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPCORE2_BASE                    (DISPID_WMPCORE_BASE + 39)
#define DISPID_WMPCORE2_DVD                     (DISPID_WMPCORE2_BASE + 1)
#define DISPID_WMPCORE3_NEWPLAYLIST             (DISPID_WMPCORE2_BASE + 2)
#define DISPID_WMPCORE3_NEWMEDIA                (DISPID_WMPCORE2_BASE + 3)

//////////////////////////////////////////////////////////////////////
// IWMPControl
//////////////////////////////////////////////////////////////////////
//
// Note: These DISPIDs need to be contiguous
//
#define DISPID_WMPCONTROLS_BASE                 DISPID_WMPCORE_BASE + DISPID_DELTA
#define DISPID_WMPCONTROLS_PLAY                 DISPID_WMPCONTROLS_BASE + 1
#define DISPID_WMPCONTROLS_STOP                 DISPID_WMPCONTROLS_BASE + 2
#define DISPID_WMPCONTROLS_PAUSE                DISPID_WMPCONTROLS_BASE + 3
#define DISPID_WMPCONTROLS_FASTFORWARD          DISPID_WMPCONTROLS_BASE + 4
#define DISPID_WMPCONTROLS_FASTREVERSE          DISPID_WMPCONTROLS_BASE + 5
#define DISPID_WMPCONTROLS_CURRENTPOSITION      DISPID_WMPCONTROLS_BASE + 6
#define DISPID_WMPCONTROLS_CURRENTPOSITIONSTRING DISPID_WMPCONTROLS_BASE + 7
#define DISPID_WMPCONTROLS_NEXT                 DISPID_WMPCONTROLS_BASE + 8
#define DISPID_WMPCONTROLS_PREVIOUS             DISPID_WMPCONTROLS_BASE + 9
#define DISPID_WMPCONTROLS_CURRENTITEM          DISPID_WMPCONTROLS_BASE + 10
#define DISPID_WMPCONTROLS_CURRENTMARKER        DISPID_WMPCONTROLS_BASE + 11
#define DISPID_WMPCONTROLS_ISAVAILABLE          DISPID_WMPCONTROLS_BASE + 12
#define DISPID_WMPCONTROLS_PLAYITEM             DISPID_WMPCONTROLS_BASE + 13
#define DISPID_WMPCONTROLS2_STEP                DISPID_WMPCONTROLS_BASE + 14
#define DISPID_WMPCONTROLS3_AUDIOLANGUAGECOUNT  DISPID_WMPCONTROLS_BASE + 15
#define DISPID_WMPCONTROLS3_GETAUDIOLANGUAGEID  DISPID_WMPCONTROLS_BASE + 16
#define DISPID_WMPCONTROLS3_GETAUDIOLANGUAGEDESC DISPID_WMPCONTROLS_BASE + 17
#define DISPID_WMPCONTROLS3_CURRENTAUDIOLANGUAGE DISPID_WMPCONTROLS_BASE + 18
#define DISPID_WMPCONTROLS3_CURRENTAUDIOLANGUAGEINDEX DISPID_WMPCONTROLS_BASE + 19
#define DISPID_WMPCONTROLS3_GETLANGUAGENAME     DISPID_WMPCONTROLS_BASE + 20
#define DISPID_WMPCONTROLS3_CURRENTPOSITIONTIMECODE DISPID_WMPCONTROLS_BASE + 21
#define DISPID_WMPCONTROLSFAKE_TIMECOMPRESSION DISPID_WMPCONTROLS_BASE + 22

//////////////////////////////////////////////////////////////////////
// IWMPSettings
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPSETTINGS_BASE                 DISPID_WMPCONTROLS_BASE + DISPID_DELTA
#define DISPID_WMPSETTINGS_AUTOSTART            DISPID_WMPSETTINGS_BASE + 1
#define DISPID_WMPSETTINGS_BALANCE              DISPID_WMPSETTINGS_BASE + 2
#define DISPID_WMPSETTINGS_INVOKEURLS           DISPID_WMPSETTINGS_BASE + 3
#define DISPID_WMPSETTINGS_MUTE                 DISPID_WMPSETTINGS_BASE + 4
#define DISPID_WMPSETTINGS_PLAYCOUNT            DISPID_WMPSETTINGS_BASE + 5
#define DISPID_WMPSETTINGS_RATE                 DISPID_WMPSETTINGS_BASE + 6
#define DISPID_WMPSETTINGS_VOLUME               DISPID_WMPSETTINGS_BASE + 7
#define DISPID_WMPSETTINGS_BASEURL              DISPID_WMPSETTINGS_BASE + 8
#define DISPID_WMPSETTINGS_DEFAULTFRAME         DISPID_WMPSETTINGS_BASE + 9
#define DISPID_WMPSETTINGS_GETMODE              DISPID_WMPSETTINGS_BASE + 10
#define DISPID_WMPSETTINGS_SETMODE              DISPID_WMPSETTINGS_BASE + 11
#define DISPID_WMPSETTINGS_ENABLEERRORDIALOGS   DISPID_WMPSETTINGS_BASE + 12
#define DISPID_WMPSETTINGS_ISAVAILABLE          DISPID_WMPSETTINGS_BASE + 13
#define DISPID_WMPSETTINGS2_DEFAULTAUDIOLANGUAGE DISPID_WMPSETTINGS_BASE + 14
#define DISPID_WMPSETTINGS2_LIBRARYACCESSRIGHTS DISPID_WMPSETTINGS_BASE + 15
#define DISPID_WMPSETTINGS2_REQUESTLIBRARYACCESSRIGHTS DISPID_WMPSETTINGS_BASE + 16

//////////////////////////////////////////////////////////////////////
// IWMPPlayList
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPPLAYLIST_BASE                 DISPID_WMPSETTINGS_BASE + DISPID_DELTA + DISPID_DELTA
#define DISPID_WMPPLAYLIST_COUNT                DISPID_WMPPLAYLIST_BASE + 1
#define DISPID_WMPPLAYLIST_NAME                 DISPID_WMPPLAYLIST_BASE + 2
#define DISPID_WMPPLAYLIST_GETITEMINFO          DISPID_WMPPLAYLIST_BASE + 3
#define DISPID_WMPPLAYLIST_SETITEMINFO          DISPID_WMPPLAYLIST_BASE + 4
#define DISPID_WMPPLAYLIST_CLEAR                DISPID_WMPPLAYLIST_BASE + 5
#define DISPID_WMPPLAYLIST_INSERTITEM           DISPID_WMPPLAYLIST_BASE + 6
#define DISPID_WMPPLAYLIST_APPENDITEM           DISPID_WMPPLAYLIST_BASE + 7
#define DISPID_WMPPLAYLIST_REMOVEITEM           DISPID_WMPPLAYLIST_BASE + 8
#define DISPID_WMPPLAYLIST_MOVEITEM             DISPID_WMPPLAYLIST_BASE + 9
#define DISPID_WMPPLAYLIST_ATTRIBUTECOUNT       DISPID_WMPPLAYLIST_BASE + 10
#define DISPID_WMPPLAYLIST_ATTRIBUTENAME        DISPID_WMPPLAYLIST_BASE + 11
#define DISPID_WMPPLAYLIST_ITEM                 DISPID_WMPPLAYLIST_BASE + 12
#define DISPID_WMPPLAYLIST_ISIDENTICAL          DISPID_WMPPLAYLIST_BASE + 13

//////////////////////////////////////////////////////////////////////
// IWMPCdrom
//////////////////////////////////////////////////////////////////////

#define DISPID_WMPCDROM_BASE                    DISPID_WMPPLAYLIST_BASE + DISPID_DELTA
#define DISPID_WMPCDROM_DRIVESPECIFIER          DISPID_WMPCDROM_BASE + 1
#define DISPID_WMPCDROM_PLAYLIST                DISPID_WMPCDROM_BASE + 2
#define DISPID_WMPCDROM_EJECT                   DISPID_WMPCDROM_BASE + 3

//////////////////////////////////////////////////////////////////////
// IWMPCdromCollection
//////////////////////////////////////////////////////////////////////

#define DISPID_WMPCDROMCOLLECTION_BASE                   DISPID_WMPCDROM_BASE + DISPID_DELTA
#define DISPID_WMPCDROMCOLLECTION_COUNT                  DISPID_WMPCDROMCOLLECTION_BASE + 1
#define DISPID_WMPCDROMCOLLECTION_ITEM                   DISPID_WMPCDROMCOLLECTION_BASE + 2
#define DISPID_WMPCDROMCOLLECTION_GETBYDRIVESPECIFIER    DISPID_WMPCDROMCOLLECTION_BASE + 3
#define DISPID_WMPCDROMCOLLECTION_STARTMONITORINGCDROMS  DISPID_WMPCDROMCOLLECTION_BASE + 4
#define DISPID_WMPCDROMCOLLECTION_STOPMONITORINGCDROMS   DISPID_WMPCDROMCOLLECTION_BASE + 5

//////////////////////////////////////////////////////////////////////
// IWMPStringCollection
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPSTRINGCOLLECTION_BASE                  (DISPID_WMPCDROMCOLLECTION_BASE + DISPID_DELTA + DISPID_DELTA)
#define DISPID_WMPSTRINGCOLLECTION_COUNT                 DISPID_WMPSTRINGCOLLECTION_BASE + 1
#define DISPID_WMPSTRINGCOLLECTION_ITEM                  DISPID_WMPSTRINGCOLLECTION_BASE + 2

//////////////////////////////////////////////////////////////////////
// IWMPMediaCollection
//////////////////////////////////////////////////////////////////////

#define DISPID_WMPMEDIACOLLECTION_BASE              DISPID_WMPSTRINGCOLLECTION_BASE + DISPID_DELTA
#define DISPID_WMPMEDIACOLLECTION_ADD               DISPID_WMPMEDIACOLLECTION_BASE + 2
#define DISPID_WMPMEDIACOLLECTION_GETALL            DISPID_WMPMEDIACOLLECTION_BASE + 3
#define DISPID_WMPMEDIACOLLECTION_GETBYNAME         DISPID_WMPMEDIACOLLECTION_BASE + 4
#define DISPID_WMPMEDIACOLLECTION_GETBYGENRE        DISPID_WMPMEDIACOLLECTION_BASE + 5
#define DISPID_WMPMEDIACOLLECTION_GETBYAUTHOR       DISPID_WMPMEDIACOLLECTION_BASE + 6
#define DISPID_WMPMEDIACOLLECTION_GETBYALBUM        DISPID_WMPMEDIACOLLECTION_BASE + 7
#define DISPID_WMPMEDIACOLLECTION_GETBYATTRIBUTE    DISPID_WMPMEDIACOLLECTION_BASE + 8
#define DISPID_WMPMEDIACOLLECTION_REMOVE            DISPID_WMPMEDIACOLLECTION_BASE + 9
#define DISPID_WMPMEDIACOLLECTION_GETATTRIBUTESTRINGCOLLECTION DISPID_WMPMEDIACOLLECTION_BASE + 11
#define DISPID_WMPMEDIACOLLECTION_NEWQUERY          DISPID_WMPMEDIACOLLECTION_BASE + 12
#define DISPID_WMPMEDIACOLLECTION_STARTMONITORING   DISPID_WMPMEDIACOLLECTION_BASE + 13
#define DISPID_WMPMEDIACOLLECTION_STOPMONITORING    DISPID_WMPMEDIACOLLECTION_BASE + 14
#define DISPID_WMPMEDIACOLLECTION_STARTCONTENTSCAN  DISPID_WMPMEDIACOLLECTION_BASE + 15
#define DISPID_WMPMEDIACOLLECTION_STOPCONTENTSCAN   DISPID_WMPMEDIACOLLECTION_BASE + 16
#define DISPID_WMPMEDIACOLLECTION_STARTSEARCH       DISPID_WMPMEDIACOLLECTION_BASE + 17
#define DISPID_WMPMEDIACOLLECTION_STOPSEARCH        DISPID_WMPMEDIACOLLECTION_BASE + 18
#define DISPID_WMPMEDIACOLLECTION_UPDATEMETADATA    DISPID_WMPMEDIACOLLECTION_BASE + 19
#define DISPID_WMPMEDIACOLLECTION_GETMEDIAATOM      DISPID_WMPMEDIACOLLECTION_BASE + 20
#define DISPID_WMPMEDIACOLLECTION_SETDELETED        DISPID_WMPMEDIACOLLECTION_BASE + 21
#define DISPID_WMPMEDIACOLLECTION_ISDELETED         DISPID_WMPMEDIACOLLECTION_BASE + 22
#define DISPID_WMPMEDIACOLLECTION_GETBYQUERYDESCRIPTION DISPID_WMPMEDIACOLLECTION_BASE + 23
#define DISPID_WMPMEDIACOLLECTION_FREEZECOLLECTIONCHANGE  DISPID_WMPMEDIACOLLECTION_BASE + 24
#define DISPID_WMPMEDIACOLLECTION_UNFREEZECOLLECTIONCHANGE DISPID_WMPMEDIACOLLECTION_BASE + 25
#define DISPID_WMPMEDIACOLLECTION_POSTCOLLECTIONCHANGE DISPID_WMPMEDIACOLLECTION_BASE + 26

//////////////////////////////////////////////////////////////////////
// IWMPPlaylistCollection
//////////////////////////////////////////////////////////////////////

#define DISPID_WMPPLAYLISTARRAY_BASE                DISPID_WMPMEDIACOLLECTION_BASE + DISPID_DELTA
#define DISPID_WMPPLAYLISTARRAY_COUNT               DISPID_WMPPLAYLISTARRAY_BASE + 1
#define DISPID_WMPPLAYLISTARRAY_ITEM                DISPID_WMPPLAYLISTARRAY_BASE + 2

//////////////////////////////////////////////////////////////////////
// IWMPPlaylistCollection
//////////////////////////////////////////////////////////////////////

#define DISPID_WMPPLAYLISTCOLLECTION_BASE           DISPID_WMPPLAYLISTARRAY_BASE + DISPID_DELTA
#define DISPID_WMPPLAYLISTCOLLECTION_NEWPLAYLIST    DISPID_WMPPLAYLISTCOLLECTION_BASE + 2
#define DISPID_WMPPLAYLISTCOLLECTION_GETALL         DISPID_WMPPLAYLISTCOLLECTION_BASE + 3
#define DISPID_WMPPLAYLISTCOLLECTION_GETBYNAME      DISPID_WMPPLAYLISTCOLLECTION_BASE + 4
#define DISPID_WMPPLAYLISTCOLLECTION_GETBYQUERYDESCRIPTION DISPID_WMPPLAYLISTCOLLECTION_BASE + 5
#define DISPID_WMPPLAYLISTCOLLECTION_REMOVE         DISPID_WMPPLAYLISTCOLLECTION_BASE + 6
#define DISPID_WMPPLAYLISTCOLLECTION_NEWQUERY       DISPID_WMPPLAYLISTCOLLECTION_BASE + 7
#define DISPID_WMPPLAYLISTCOLLECTION_STARTMONITORING DISPID_WMPPLAYLISTCOLLECTION_BASE + 8
#define DISPID_WMPPLAYLISTCOLLECTION_STOPMONITORING DISPID_WMPPLAYLISTCOLLECTION_BASE + 9
#define DISPID_WMPPLAYLISTCOLLECTION_SETDELETED     DISPID_WMPPLAYLISTCOLLECTION_BASE + 10
#define DISPID_WMPPLAYLISTCOLLECTION_ISDELETED      DISPID_WMPPLAYLISTCOLLECTION_BASE + 11
#define DISPID_WMPPLAYLISTCOLLECTION_IMPORTPLAYLIST DISPID_WMPPLAYLISTCOLLECTION_BASE + 12

//////////////////////////////////////////////////////////////////////
//  IWMPMedia
//////////////////////////////////////////////////////////////////////

#define DISPID_WMPMEDIA_BASE                            (DISPID_WMPPLAYLISTCOLLECTION_BASE + (4 * DISPID_DELTA))
#define DISPID_WMPMEDIA_SOURCEURL                       DISPID_WMPMEDIA_BASE + 1
#define DISPID_WMPMEDIA_IMAGESOURCEWIDTH                DISPID_WMPMEDIA_BASE + 2
#define DISPID_WMPMEDIA_IMAGESOURCEHEIGHT               DISPID_WMPMEDIA_BASE + 3
#define DISPID_WMPMEDIA_MARKERCOUNT                     DISPID_WMPMEDIA_BASE + 4
#define DISPID_WMPMEDIA_GETMARKERTIME                   DISPID_WMPMEDIA_BASE + 5
#define DISPID_WMPMEDIA_GETMARKERNAME                   DISPID_WMPMEDIA_BASE + 6
#define DISPID_WMPMEDIA_DURATION                        DISPID_WMPMEDIA_BASE + 7
#define DISPID_WMPMEDIA_DURATIONSTRING                  DISPID_WMPMEDIA_BASE + 8
#define DISPID_WMPMEDIA_ATTRIBUTECOUNT                  DISPID_WMPMEDIA_BASE + 9
#define DISPID_WMPMEDIA_GETATTRIBUTENAME                DISPID_WMPMEDIA_BASE + 10
#define DISPID_WMPMEDIA_GETITEMINFO                     DISPID_WMPMEDIA_BASE + 11
#define DISPID_WMPMEDIA_SETITEMINFO                     DISPID_WMPMEDIA_BASE + 12
#define DISPID_WMPMEDIA_ISIDENTICAL                     DISPID_WMPMEDIA_BASE + 13
#define DISPID_WMPMEDIA_NAME                            DISPID_WMPMEDIA_BASE + 14
#define DISPID_WMPMEDIA_GETITEMINFOBYATOM               DISPID_WMPMEDIA_BASE + 15
#define DISPID_WMPMEDIA_ISMEMBEROF                      DISPID_WMPMEDIA_BASE + 16
#define DISPID_WMPMEDIA_ISREADONLYITEM                  DISPID_WMPMEDIA_BASE + 17
#define DISPID_WMPMEDIA2_ERROR                          DISPID_WMPMEDIA_BASE + 18
#define DISPID_WMPMEDIA3_GETATTRIBUTECOUNTBYTYPE        DISPID_WMPMEDIA_BASE + 19
#define DISPID_WMPMEDIA3_GETITEMINFOBYTYPE              DISPID_WMPMEDIA_BASE + 20

//////////////////////////////////////////////////////////////////////
//  IWMPNetwork
//////////////////////////////////////////////////////////////////////

#define DISPID_WMPNETWORK_BASE                            DISPID_WMPMEDIA_BASE + DISPID_DELTA
#define DISPID_WMPNETWORK_BANDWIDTH                       DISPID_WMPNETWORK_BASE + 1
#define DISPID_WMPNETWORK_RECOVEREDPACKETS                DISPID_WMPNETWORK_BASE + 2
#define DISPID_WMPNETWORK_SOURCEPROTOCOL                  DISPID_WMPNETWORK_BASE + 3
#define DISPID_WMPNETWORK_RECEIVEDPACKETS                 DISPID_WMPNETWORK_BASE + 4
#define DISPID_WMPNETWORK_LOSTPACKETS                     DISPID_WMPNETWORK_BASE + 5
#define DISPID_WMPNETWORK_RECEPTIONQUALITY                DISPID_WMPNETWORK_BASE + 6
#define DISPID_WMPNETWORK_BUFFERINGCOUNT                  DISPID_WMPNETWORK_BASE + 7
#define DISPID_WMPNETWORK_BUFFERINGPROGRESS               DISPID_WMPNETWORK_BASE + 8
#define DISPID_WMPNETWORK_BUFFERINGTIME                   DISPID_WMPNETWORK_BASE + 9
#define DISPID_WMPNETWORK_FRAMERATE                       DISPID_WMPNETWORK_BASE + 10
#define DISPID_WMPNETWORK_MAXBITRATE                      DISPID_WMPNETWORK_BASE + 11
#define DISPID_WMPNETWORK_BITRATE                         DISPID_WMPNETWORK_BASE + 12
#define DISPID_WMPNETWORK_GETPROXYSETTINGS                DISPID_WMPNETWORK_BASE + 13
#define DISPID_WMPNETWORK_SETPROXYSETTINGS                DISPID_WMPNETWORK_BASE + 14
#define DISPID_WMPNETWORK_GETPROXYNAME                    DISPID_WMPNETWORK_BASE + 15
#define DISPID_WMPNETWORK_SETPROXYNAME                    DISPID_WMPNETWORK_BASE + 16
#define DISPID_WMPNETWORK_GETPROXYPORT                    DISPID_WMPNETWORK_BASE + 17
#define DISPID_WMPNETWORK_SETPROXYPORT                    DISPID_WMPNETWORK_BASE + 18
#define DISPID_WMPNETWORK_GETPROXYEXCEPTIONLIST           DISPID_WMPNETWORK_BASE + 19
#define DISPID_WMPNETWORK_SETPROXYEXCEPTIONLIST           DISPID_WMPNETWORK_BASE + 20
#define DISPID_WMPNETWORK_GETPROXYBYPASSFORLOCAL          DISPID_WMPNETWORK_BASE + 21
#define DISPID_WMPNETWORK_SETPROXYBYPASSFORLOCAL          DISPID_WMPNETWORK_BASE + 22
#define DISPID_WMPNETWORK_MAXBANDWIDTH                    DISPID_WMPNETWORK_BASE + 23
#define DISPID_WMPNETWORK_DOWNLOADPROGRESS                DISPID_WMPNETWORK_BASE + 24
#define DISPID_WMPNETWORK_ENCODEDFRAMERATE                DISPID_WMPNETWORK_BASE + 25
#define DISPID_WMPNETWORK_FRAMESSKIPPED                   DISPID_WMPNETWORK_BASE + 26

//////////////////////////////////////////////////////////////////////
// IWMPError
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPERROR_BASE                            DISPID_WMPNETWORK_BASE + DISPID_DELTA
#define DISPID_WMPERROR_CLEARERRORQUEUE                 DISPID_WMPERROR_BASE + 1
#define DISPID_WMPERROR_ERRORCOUNT                      DISPID_WMPERROR_BASE + 2
#define DISPID_WMPERROR_ITEM                            DISPID_WMPERROR_BASE + 3
#define DISPID_WMPERROR_WEBHELP                         DISPID_WMPERROR_BASE + 4

//////////////////////////////////////////////////////////////////////
// IWMPErrorItem
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPERRORITEM_BASE                    DISPID_WMPERROR_BASE + DISPID_DELTA
#define DISPID_WMPERRORITEM_ERRORCODE               DISPID_WMPERRORITEM_BASE + 1
#define DISPID_WMPERRORITEM_ERRORDESCRIPTION        DISPID_WMPERRORITEM_BASE + 2
#define DISPID_WMPERRORITEM_ERRORCONTEXT            DISPID_WMPERRORITEM_BASE + 3
#define DISPID_WMPERRORITEM_REMEDY                  DISPID_WMPERRORITEM_BASE + 4
#define DISPID_WMPERRORITEM_CUSTOMURL               DISPID_WMPERRORITEM_BASE + 5
#define DISPID_WMPERRORITEM2_CONDITION              DISPID_WMPERRORITEM_BASE + 6

/////////////////////////////////////////////////////////////////////////
// IWMPClosedCaption
/////////////////////////////////////////////////////////////////////////
#define DISPID_WMPCLOSEDCAPTION_BASE                   DISPID_WMPERRORITEM_BASE + DISPID_DELTA
#define DISPID_WMPCLOSEDCAPTION_SAMISTYLE              DISPID_WMPCLOSEDCAPTION_BASE + 1
#define DISPID_WMPCLOSEDCAPTION_SAMILANG               DISPID_WMPCLOSEDCAPTION_BASE + 2
#define DISPID_WMPCLOSEDCAPTION_SAMIFILENAME           DISPID_WMPCLOSEDCAPTION_BASE + 3
#define DISPID_WMPCLOSEDCAPTION_CAPTIONINGID           DISPID_WMPCLOSEDCAPTION_BASE + 4
#define DISPID_WMPCLOSEDCAPTION2_GETLANGCOUNT          DISPID_WMPCLOSEDCAPTION_BASE + 5
#define DISPID_WMPCLOSEDCAPTION2_GETLANGNAME           DISPID_WMPCLOSEDCAPTION_BASE + 6
#define DISPID_WMPCLOSEDCAPTION2_GETLANGID             DISPID_WMPCLOSEDCAPTION_BASE + 7
#define DISPID_WMPCLOSEDCAPTION2_GETSTYLECOUNT         DISPID_WMPCLOSEDCAPTION_BASE + 8
#define DISPID_WMPCLOSEDCAPTION2_GETSTYLENAME          DISPID_WMPCLOSEDCAPTION_BASE + 9

/////////////////////////////////////////////////////////////////////////
// IWMPDVD
/////////////////////////////////////////////////////////////////////////
#define DISPID_WMPDVD_BASE                              DISPID_WMPCLOSEDCAPTION_BASE + DISPID_DELTA
#define DISPID_WMPDVD_ISAVAILABLE                       DISPID_WMPDVD_BASE + 1
#define DISPID_WMPDVD_DOMAIN                            DISPID_WMPDVD_BASE + 2
#define DISPID_WMPDVD_TOPMENU                           DISPID_WMPDVD_BASE + 3
#define DISPID_WMPDVD_TITLEMENU                         DISPID_WMPDVD_BASE + 4
#define DISPID_WMPDVD_BACK                              DISPID_WMPDVD_BASE + 5
#define DISPID_WMPDVD_RESUME                            DISPID_WMPDVD_BASE + 6

//////////////////////////////////////////////////////////////////////
// IWMPMetadata* interfaces
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPMETADATA_BASE                                 DISPID_WMPDVD_BASE + DISPID_DELTA
#define DISPID_WMPMETADATA_PICTURE_MIMETYPE                     DISPID_WMPMETADATA_BASE + 1
#define DISPID_WMPMETADATA_PICTURE_PICTURETYPE                  DISPID_WMPMETADATA_BASE + 2
#define DISPID_WMPMETADATA_PICTURE_DESCRIPTION                  DISPID_WMPMETADATA_BASE + 3
#define DISPID_WMPMETADATA_PICTURE_URL                          DISPID_WMPMETADATA_BASE + 4
#define DISPID_WMPMETADATA_TEXT_TEXT                            DISPID_WMPMETADATA_BASE + 5
#define DISPID_WMPMETADATA_TEXT_DESCRIPTION                     DISPID_WMPMETADATA_BASE + 6

//////////////////////////////////////////////////////////////////////
// IWMPPlayerApplication
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPPLAYERAPP_BASE                        DISPID_WMPMETADATA_BASE + DISPID_DELTA
#define DISPID_WMPPLAYERAPP_SWITCHTOPLAYERAPPLICATION   DISPID_WMPPLAYERAPP_BASE + 1
#define DISPID_WMPPLAYERAPP_SWITCHTOCONTROL             DISPID_WMPPLAYERAPP_BASE + 2
#define DISPID_WMPPLAYERAPP_PLAYERDOCKED                DISPID_WMPPLAYERAPP_BASE + 3
#define DISPID_WMPPLAYERAPP_HASDISPLAY                  DISPID_WMPPLAYERAPP_BASE + 4
#define DISPID_WMPPLAYERAPP_REMOTESTATUS                DISPID_WMPPLAYERAPP_BASE + 5

//////////////////////////////////////////////////////////////////////
// IWMPDownloadManager
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPDOWNLOADMANAGER_BASE                      DISPID_WMPPLAYERAPP_BASE + DISPID_DELTA
#define DISPID_WMPDOWNLOADMANAGER_GETDOWNLOADCOLLECTION     DISPID_WMPDOWNLOADMANAGER_BASE + 1
#define DISPID_WMPDOWNLOADMANAGER_CREATEDOWNLOADCOLLECTION  DISPID_WMPDOWNLOADMANAGER_BASE + 2

//////////////////////////////////////////////////////////////////////
// IWMPDownloadCollection
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPDOWNLOADCOLLECTION_BASE               DISPID_WMPDOWNLOADMANAGER_BASE + DISPID_DELTA
#define DISPID_WMPDOWNLOADCOLLECTION_ID                 DISPID_WMPDOWNLOADCOLLECTION_BASE + 1
#define DISPID_WMPDOWNLOADCOLLECTION_COUNT              DISPID_WMPDOWNLOADCOLLECTION_BASE + 2
#define DISPID_WMPDOWNLOADCOLLECTION_ITEM               DISPID_WMPDOWNLOADCOLLECTION_BASE + 3
#define DISPID_WMPDOWNLOADCOLLECTION_STARTDOWNLOAD      DISPID_WMPDOWNLOADCOLLECTION_BASE + 4
#define DISPID_WMPDOWNLOADCOLLECTION_REMOVEITEM         DISPID_WMPDOWNLOADCOLLECTION_BASE + 5
#define DISPID_WMPDOWNLOADCOLLECTION_CLEAR              DISPID_WMPDOWNLOADCOLLECTION_BASE + 6

//////////////////////////////////////////////////////////////////////
// IWMPDownloadItem
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPDOWNLOADITEM_BASE                     DISPID_WMPDOWNLOADCOLLECTION_BASE + DISPID_DELTA
#define DISPID_WMPDOWNLOADITEM_SOURCEURL                DISPID_WMPDOWNLOADITEM_BASE + 1
#define DISPID_WMPDOWNLOADITEM_SIZE                     DISPID_WMPDOWNLOADITEM_BASE + 2
#define DISPID_WMPDOWNLOADITEM_TYPE                     DISPID_WMPDOWNLOADITEM_BASE + 3
#define DISPID_WMPDOWNLOADITEM_PROGRESS                 DISPID_WMPDOWNLOADITEM_BASE + 4
#define DISPID_WMPDOWNLOADITEM_DOWNLOADSTATE            DISPID_WMPDOWNLOADITEM_BASE + 5
#define DISPID_WMPDOWNLOADITEM_PAUSE                    DISPID_WMPDOWNLOADITEM_BASE + 6
#define DISPID_WMPDOWNLOADITEM_RESUME                   DISPID_WMPDOWNLOADITEM_BASE + 7
#define DISPID_WMPDOWNLOADITEM_CANCEL                   DISPID_WMPDOWNLOADITEM_BASE + 8

//////////////////////////////////////////////////////////////////////
// IWMPDownloadItem2
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPDOWNLOADITEM2_BASE                    DISPID_WMPDOWNLOADITEM_BASE + DISPID_DELTA
#define DISPID_WMPDOWNLOADITEM2_GETITEMINFO             DISPID_WMPDOWNLOADITEM2_BASE + 1

//////////////////////////////////////////////////////////////////////
// IWMPQuery
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPQUERY_BASE                            DISPID_WMPDOWNLOADITEM2_BASE + DISPID_DELTA
#define DISPID_WMPQUERY_ADDCONDITION                    DISPID_WMPQUERY_BASE + 1
#define DISPID_WMPQUERY_BEGINNEXTGROUP                  DISPID_WMPQUERY_BASE + 2

//////////////////////////////////////////////////////////////////////
// IWMPMediaCollection2
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPMEDIACOLLECTION2_BASE                     DISPID_WMPQUERY_BASE + DISPID_DELTA
#define DISPID_WMPMEDIACOLLECTION2_CREATEQUERY              DISPID_WMPMEDIACOLLECTION2_BASE + 1
#define DISPID_WMPMEDIACOLLECTION2_GETPLAYLISTBYQUERY       DISPID_WMPMEDIACOLLECTION2_BASE + 2
#define DISPID_WMPMEDIACOLLECTION2_GETSTRINGCOLLBYQUERY     DISPID_WMPMEDIACOLLECTION2_BASE + 3
#define DISPID_WMPMEDIACOLLECTION2_GETBYATTRANDMEDIATYPE    DISPID_WMPMEDIACOLLECTION2_BASE + 4

//////////////////////////////////////////////////////////////////////
// IWMPStringCollection2
//////////////////////////////////////////////////////////////////////
#define DISPID_WMPSTRINGCOLLECTION2_BASE                 DISPID_WMPMEDIACOLLECTION2_BASE + DISPID_DELTA
#define DISPID_WMPSTRINGCOLLECTION2_ISIDENTICAL          DISPID_WMPSTRINGCOLLECTION2_BASE + 1
#define DISPID_WMPSTRINGCOLLECTION2_GETITEMINFO          DISPID_WMPSTRINGCOLLECTION2_BASE + 2
#define DISPID_WMPSTRINGCOLLECTION2_GETATTRCOUNTBYTYPE   DISPID_WMPSTRINGCOLLECTION2_BASE + 3
#define DISPID_WMPSTRINGCOLLECTION2_GETITEMINFOBYTYPE    DISPID_WMPSTRINGCOLLECTION2_BASE + 4


/////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////
#define DISPID_WMPCORE_MIN                      1
#define DISPID_WMPCORE_MAX                      DISPID_WMPSTRINGCOLLECTION2_GETITEMINFOBYTYPE


//////////////////////////////////////////////////////////////////////
// DIID_WMPCoreEvents
//////////////////////////////////////////////////////////////////////
#define WMPCOREEVENT_BASE                       5000
#define DISPID_WMPCOREEVENT_OPENSTATECHANGE     (WMPCOREEVENT_BASE + 1)
#define DISPID_WMPCOREEVENT_STATUSCHANGE        (WMPCOREEVENT_BASE + 2)


#define WMPCOREEVENT_CONTROL_BASE               5100
#define DISPID_WMPCOREEVENT_PLAYSTATECHANGE     (WMPCOREEVENT_CONTROL_BASE + 1)
#define DISPID_WMPCOREEVENT_AUDIOLANGUAGECHANGE (WMPCOREEVENT_CONTROL_BASE + 2)

#define WMPCOREEVENT_SEEK_BASE                  5200
#define DISPID_WMPCOREEVENT_ENDOFSTREAM         (WMPCOREEVENT_SEEK_BASE + 1)
#define DISPID_WMPCOREEVENT_POSITIONCHANGE      (WMPCOREEVENT_SEEK_BASE + 2)
#define DISPID_WMPCOREEVENT_MARKERHIT           (WMPCOREEVENT_SEEK_BASE + 3)
#define DISPID_WMPCOREEVENT_DURATIONUNITCHANGE  (WMPCOREEVENT_SEEK_BASE + 4)

#define WMPCOREEVENT_CONTENT_BASE               5300
#define DISPID_WMPCOREEVENT_SCRIPTCOMMAND       (WMPCOREEVENT_CONTENT_BASE + 1)

#define WMPCOREEVENT_NETWORK_BASE               5400
#define DISPID_WMPCOREEVENT_DISCONNECT          (WMPCOREEVENT_NETWORK_BASE + 1)
#define DISPID_WMPCOREEVENT_BUFFERING           (WMPCOREEVENT_NETWORK_BASE + 2)
#define DISPID_WMPCOREEVENT_NEWSTREAM           (WMPCOREEVENT_NETWORK_BASE + 3)

#define WMPCOREEVENT_ERROR_BASE                 5500
#define DISPID_WMPCOREEVENT_ERROR               (WMPCOREEVENT_ERROR_BASE + 1)

#define WMPCOREEVENT_WARNING_BASE               5600
#define DISPID_WMPCOREEVENT_WARNING             (WMPCOREEVENT_WARNING_BASE + 1)

#define WMPCOREEVENT_CDROM_BASE                 5700
#define DISPID_WMPCOREEVENT_CDROMMEDIACHANGE    (WMPCOREEVENT_CDROM_BASE + 1)

#define WMPCOREEVENT_PLAYLIST_BASE                                      5800
#define DISPID_WMPCOREEVENT_PLAYLISTCHANGE                              (WMPCOREEVENT_PLAYLIST_BASE + 1)
#define DISPID_WMPCOREEVENT_MEDIACHANGE                                 (WMPCOREEVENT_PLAYLIST_BASE + 2)
#define DISPID_WMPCOREEVENT_CURRENTMEDIAITEMAVAILABLE                   (WMPCOREEVENT_PLAYLIST_BASE + 3)
#define DISPID_WMPCOREEVENT_CURRENTPLAYLISTCHANGE                       (WMPCOREEVENT_PLAYLIST_BASE + 4)
#define DISPID_WMPCOREEVENT_CURRENTPLAYLISTITEMAVAILABLE                (WMPCOREEVENT_PLAYLIST_BASE + 5)
#define DISPID_WMPCOREEVENT_CURRENTITEMCHANGE                           (WMPCOREEVENT_PLAYLIST_BASE + 6)
#define DISPID_WMPCOREEVENT_MEDIACOLLECTIONCHANGE                       (WMPCOREEVENT_PLAYLIST_BASE + 7)
#define DISPID_WMPCOREEVENT_MEDIACOLLECTIONATTRIBUTESTRINGADDED         (WMPCOREEVENT_PLAYLIST_BASE + 8)
#define DISPID_WMPCOREEVENT_MEDIACOLLECTIONATTRIBUTESTRINGREMOVED       (WMPCOREEVENT_PLAYLIST_BASE + 9)
#define DISPID_WMPCOREEVENT_PLAYLISTCOLLECTIONCHANGE                    (WMPCOREEVENT_PLAYLIST_BASE + 10)
#define DISPID_WMPCOREEVENT_PLAYLISTCOLLECTIONPLAYLISTADDED             (WMPCOREEVENT_PLAYLIST_BASE + 11)
#define DISPID_WMPCOREEVENT_PLAYLISTCOLLECTIONPLAYLISTREMOVED           (WMPCOREEVENT_PLAYLIST_BASE + 12)
#define DISPID_WMPCOREEVENT_MEDIACOLLECTIONCONTENTSCANADDEDITEM         (WMPCOREEVENT_PLAYLIST_BASE + 13)
#define DISPID_WMPCOREEVENT_MEDIACOLLECTIONCONTENTSCANPROGRESS          (WMPCOREEVENT_PLAYLIST_BASE + 14)
#define DISPID_WMPCOREEVENT_MEDIACOLLECTIONSEARCHFOUNDITEM              (WMPCOREEVENT_PLAYLIST_BASE + 15)
#define DISPID_WMPCOREEVENT_MEDIACOLLECTIONSEARCHPROGRESS               (WMPCOREEVENT_PLAYLIST_BASE + 16)
#define DISPID_WMPCOREEVENT_MEDIACOLLECTIONSEARCHCOMPLETE               (WMPCOREEVENT_PLAYLIST_BASE + 17)
#define DISPID_WMPCOREEVENT_PLAYLISTCOLLECTIONPLAYLISTSETASDELETED      (WMPCOREEVENT_PLAYLIST_BASE + 18)
#define DISPID_WMPCOREEVENT_MODECHANGE                                  (WMPCOREEVENT_PLAYLIST_BASE + 19)
#define DISPID_WMPCOREEVENT_MEDIACOLLECTIONATTRIBUTESTRINGCHANGED       (WMPCOREEVENT_PLAYLIST_BASE + 20)
#define DISPID_WMPCOREEVENT_MEDIAERROR                                  (WMPCOREEVENT_PLAYLIST_BASE + 21)
#define DISPID_WMPCOREEVENT_DOMAINCHANGE                                (WMPCOREEVENT_PLAYLIST_BASE + 22)
#define DISPID_WMPCOREEVENT_OPENPLAYLISTSWITCH                          (WMPCOREEVENT_PLAYLIST_BASE + 23)
#define DISPID_WMPCOREEVENT_STRINGCOLLECTIONCHANGE                      (WMPCOREEVENT_PLAYLIST_BASE + 24)
#define DISPID_WMPCOREEVENT_MEDIACOLLECTIONMEDIAADDED                   (WMPCOREEVENT_PLAYLIST_BASE + 25)
#define DISPID_WMPCOREEVENT_MEDIACOLLECTIONMEDIAREMOVED                 (WMPCOREEVENT_PLAYLIST_BASE + 26)



//////////////////////////////////////////////////////////////////////
// DIID_WMPOCXEvents
//
// These are the events that will be fired from OCX itself
//////////////////////////////////////////////////////////////////////
#define WMPOCXEVENT_BASE                        6500
#define DISPID_WMPOCXEVENT_SWITCHEDTOPLAYERAPPLICATION      (WMPOCXEVENT_BASE + 1)
#define DISPID_WMPOCXEVENT_SWITCHEDTOCONTROL                (WMPOCXEVENT_BASE + 2)
#define DISPID_WMPOCXEVENT_PLAYERDOCKEDSTATECHANGE          (WMPOCXEVENT_BASE + 3)
#define DISPID_WMPOCXEVENT_PLAYERRECONNECT                  (WMPOCXEVENT_BASE + 4)
#define DISPID_WMPOCXEVENT_CLICK                            (WMPOCXEVENT_BASE + 5)
#define DISPID_WMPOCXEVENT_DOUBLECLICK                      (WMPOCXEVENT_BASE + 6)
#define DISPID_WMPOCXEVENT_KEYDOWN                          (WMPOCXEVENT_BASE + 7)
#define DISPID_WMPOCXEVENT_KEYPRESS                         (WMPOCXEVENT_BASE + 8)
#define DISPID_WMPOCXEVENT_KEYUP                            (WMPOCXEVENT_BASE + 9)
#define DISPID_WMPOCXEVENT_MOUSEDOWN                        (WMPOCXEVENT_BASE + 10)
#define DISPID_WMPOCXEVENT_MOUSEMOVE                        (WMPOCXEVENT_BASE + 11)
#define DISPID_WMPOCXEVENT_MOUSEUP                          (WMPOCXEVENT_BASE + 12)
#define DISPID_WMPOCXEVENT_DEVICECONNECT                    (WMPOCXEVENT_BASE + 13)
#define DISPID_WMPOCXEVENT_DEVICEDISCONNECT                 (WMPOCXEVENT_BASE + 14)
#define DISPID_WMPOCXEVENT_DEVICESTATUSCHANGE               (WMPOCXEVENT_BASE + 15)
#define DISPID_WMPOCXEVENT_DEVICESYNCSTATECHANGE            (WMPOCXEVENT_BASE + 16)
#define DISPID_WMPOCXEVENT_DEVICESYNCERROR                  (WMPOCXEVENT_BASE + 17)
#define DISPID_WMPOCXEVENT_CREATEPARTNERSHIPCOMPLETE        (WMPOCXEVENT_BASE + 18)
#define DISPID_WMPOCXEVENT_CDROMRIPSTATECHANGE              (WMPOCXEVENT_BASE + 19)
#define DISPID_WMPOCXEVENT_CDROMRIPMEDIAERROR               (WMPOCXEVENT_BASE + 20)
#define DISPID_WMPOCXEVENT_CDROMBURNSTATECHANGE             (WMPOCXEVENT_BASE + 21)
#define DISPID_WMPOCXEVENT_CDROMBURNMEDIAERROR              (WMPOCXEVENT_BASE + 22)
#define DISPID_WMPOCXEVENT_CDROMBURNERROR                   (WMPOCXEVENT_BASE + 23)
#define DISPID_WMPOCXEVENT_LIBRARYCONNECT                   (WMPOCXEVENT_BASE + 24)
#define DISPID_WMPOCXEVENT_LIBRARYDISCONNECT                (WMPOCXEVENT_BASE + 25)
#define DISPID_WMPOCXEVENT_FOLDERSCANSTATECHANGE            (WMPOCXEVENT_BASE + 26)



//*****************************************************************************
//
//  End of File
//
//*****************************************************************************

